'From Squeak3.5 of ''11 April 2003'' [latest update: #5180] on 10 February 2004 at 12:50:27 pm'!
Object subclass: #BowlingScore
	instanceVariableNames: 'ball frame lastFrameScored score pins name pinCountList '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'My Stuff'!

!BowlingScore methodsFor: 'initialization' stamp: 'DY 2/7/2004 16:52'!
initialize: bowlerName
	"Initialize bowling score object for a bowler with the given name."
	name := bowlerName.
	score := Array new: 10.
     1 to: 10 do: [:i | score at: i put: 0].
	pins := (Array new: 10).
	1 to: 9 do: [:i | pins at: i put: (Array new: 2). 
                           (pins at: i) at: 1 put: 0.
					   (pins at: i) at: 2 put: 0
                  ].
	pins at: 10 put: (Array new: 3).
	(pins at: 10) at: 1 put: 0.
	(pins at: 10) at: 2 put: 0.
	(pins at: 10) at: 3 put: 0.
	pinCountList := OrderedCollection new.
	ball := frame := 1.
	lastFrameScored := 0.	
	^self
! !


!BowlingScore methodsFor: 'private' stamp: 'DY 1/31/2004 17:47'!
updateScore
	| f scoring |
	scoring := true.
	f := lastFrameScored+1.
	[(self bowlerIsPast: f) & scoring & (f > 10) not]
		whileTrue: [
			(self isStrike: f) ifTrue: [
				(f = 9 & self gameFinished) ifTrue: [
					score at: f put: (score at: f-1) + 10 + ((pins at: 10) at: 1) + ((pins at: 10) at: 2) 
				] ifFalse: [
					(f = 10 & self gameFinished) ifTrue: [
						score at: f put: (score at: f-1) + 10 + ((pins at: 10) at: 2) + ((pins at: 10) at: 3) 
					] ifFalse: [
						(self isStrike: f+1) ifTrue: [
							(self bowlerIsPast: f+2 ball: 1) ifTrue: [
								| prev |
								prev := 0.
								f > 1 ifTrue: [ prev := (score at: f-1) ].
								score at: f put: prev + 20 +((pins at: f+2) at: 1)
							] ifFalse: [scoring := false]
						] ifFalse: [
							| prev |
							prev := 0.
							f > 1 ifTrue: [ prev := (score at: f-1) ].
							(self bowlerIsPast: f+1 ball: 2) ifTrue: [
								score at: f put: prev + 10 + ((pins at: f+1) at: 1) + ((pins at: f+1) at: 2)
							] ifFalse: [ scoring := false ]
						]
					]
				]
			]
			ifFalse: [
				(self isSpare: f) ifTrue: [
					(f < 10) & (self bowlerIsPast: f+1 ball: 1) ifTrue: [
						| prev |
						prev := 0.
						f > 1 ifTrue: [ prev := (score at: f-1) ].
						score at: f put: prev + 10 + ((pins at: f+1) at: 1)
					] ifFalse: [
						(f = 10) & (self bowlerIsPast: f ball: 3) ifTrue: [
							score at: f put: (score at: f-1) + 10 + ((pins at: f) at: 3)
						] ifFalse: [ scoring := false ]
					]
				] ifFalse: [
					| prev |
					prev := 0.
					f > 1 ifTrue: [ prev := (score at: f-1) ].
					score at: f put: prev + ((pins at: f) at: 1) + ((pins at: f) at: 2)
				]
			].
			scoring ifTrue: [ lastFrameScored := f ].
			f := f+1.
		 ]
! !



!BowlingScore methodsFor: 'display' stamp: 'DY 1/29/2004 00:06'!
displayScore

	| spaces characters digits |
	Transcript show:  '                      '.
	1 to: frame-1 do: [ :i |
		Transcript show: 9 asCharacter.
		(self isStrike: i) ifTrue: [
			Transcript show: '   X '
		] ifFalse: [
			(self isSpare: i) ifTrue: [
				Transcript show: '  ', ((pins at: i) at: 1) printString, ' /'
			] ifFalse: [
				Transcript show: '  ', ((pins at: i) at: 1) printString, ' ', ((pins at: i) at: 2) printString
			]
		]
	].
	Transcript show: 9 asCharacter.
	self gameFinished ifTrue: [
		(self isStrike: 10) ifTrue: [
			Transcript show: '  X'.
			((pins at: 10) at: 2) = 10 ifTrue: [
				Transcript show: 'X'.
			] ifFalse: [
				Transcript show: ((pins at: 10) at: 2)
			].
			((pins at: 10) at: 3) = 10 ifTrue: [
				Transcript show: 'X'
			] ifFalse: [
				((pins at: 10) at: 2) = 10 ifTrue: [
					Transcript show: ((pins at: 10) at: 3)
				] ifFalse: [
					((pins at: 10) at: 2) + ((pins at: 10) at: 3) = 10 ifTrue: [
						Transcript show: '/'
					] ifFalse: [
						Transcript show: ((pins at: 10) at: 3)
					]
				]
			]
		] ifFalse: [
			(self isSpare: 10) ifTrue: [
				Transcript show: ((pins at: 10) at: 1) printString, '/'.
				((pins at: 10) at: 3) = 10 ifTrue: [Transcript show: 'X'] ifFalse: [Transcript show: ((pins at: 10) at: 3)]
			] ifFalse: [
				Transcript show: '  ', ((pins at: 10) at: 1) printString, ' ', ((pins at: 10) at: 2) printString
			]
		]
	].
	Transcript show: Character cr.
	characters := name size.
	characters > 15 ifTrue: [ characters = 15 ].
	1 to: characters do: [ :i | Transcript show: (name at: i) ].
	spaces := 15 - characters.
	spaces timesRepeat: [Transcript show: ' '].
	1 to: lastFrameScored do: [ :i |
		Transcript show: 9 asCharacter.
		digits := (score at: i) printString size.
		spaces := 5 - digits.
		spaces timesRepeat: [ Transcript show: ' ' ].
		Transcript show: (score at: i)
	].
	Transcript show: Character cr! !


!BowlingScore methodsFor: 'access functions' stamp: 'DY 2/4/2004 19:11'!
ball
^ball! !

!BowlingScore methodsFor: 'access functions' stamp: 'DY 1/28/2004 21:16'!
bowlerIsPast: f

^ frame > f | self gameFinished! !

!BowlingScore methodsFor: 'access functions' stamp: 'DY 1/28/2004 21:17'!
bowlerIsPast: f ball: b

^ (frame > f) | (frame = f & (ball > b)) | self gameFinished! !

!BowlingScore methodsFor: 'access functions' stamp: 'DY 2/4/2004 19:06'!
bowlerName
^ name! !

!BowlingScore methodsFor: 'access functions' stamp: 'DY 2/4/2004 19:11'!
frame
^frame! !

!BowlingScore methodsFor: 'access functions' stamp: 'DY 1/28/2004 20:58'!
gameFinished

	^ (frame = 10) & (ball = 4) |
	  ((self isOpenFrame: 10) & (ball = 3))! !

!BowlingScore methodsFor: 'access functions' stamp: 'DY 2/9/2004 15:28'!
getLastPinCount
	^ pinCountList last! !

!BowlingScore methodsFor: 'access functions' stamp: 'DY 2/7/2004 16:54'!
getPinCountList
	^ pinCountList! !

!BowlingScore methodsFor: 'access functions' stamp: 'DY 1/28/2004 21:01'!
isOpenFrame: f

	^(frame < f) not & (((pins at: f) at: 1) + ((pins at: f) at: 2) < 10)! !

!BowlingScore methodsFor: 'access functions' stamp: 'DY 1/28/2004 19:46'!
isSpare: n
"Return true if the n-th frame is a spare"

^ ((pins at: n) at: 1) ~~ 10 & ((((pins at: n) at: 1) + ((pins at: n) at: 2)) = 10)! !

!BowlingScore methodsFor: 'access functions' stamp: 'DY 1/28/2004 19:49'!
isStrike: n
"Return true if the n-th frame is a strike"

^ ((pins at: n) at: 1) = 10! !

!BowlingScore methodsFor: 'access functions' stamp: 'DY 2/4/2004 19:14'!
lastFrameScored
^lastFrameScored! !

!BowlingScore methodsFor: 'access functions' stamp: 'DY 2/9/2004 15:42'!
pinsAt: f at: b

	^ (pins at: f) at: b! !

!BowlingScore methodsFor: 'access functions' stamp: 'DY 2/7/2004 16:53'!
putBall: pinCount 
	| totalPinsThisFrame |
	self gameFinished ifTrue: [^false].
	pinCount < 0
		ifTrue: [^ false].
	pinCount > 10
		ifTrue: [^ false].
	totalPinsThisFrame _ 0.
	(pins at: frame)
		at: ball
		put: pinCount.
	1
		to: ball
		do: [:i | totalPinsThisFrame _ totalPinsThisFrame
						+ ((pins at: frame)
								at: i)].
	(frame < 10 & (totalPinsThisFrame > 10)) | 
	(frame = 10 & (totalPinsThisFrame > 10) & (self isSpare: 10) not & (self isStrike: 10) not) |
	(frame = 10 & (totalPinsThisFrame > 20) & (self isStrike: 10) not) |
	(frame = 10 & (self isStrike: 10) & ((((pins at: frame) at: 2) = 10) not) & (totalPinsThisFrame > 20)) |
	(totalPinsThisFrame > 30) 
		ifTrue: [
			(pins at: frame) at: ball put: 0.
			^ false
		].
	(frame < 10) & ( (ball = 2) | (ball = 1 & (pinCount = 10)))
		ifTrue: [
			frame := frame + 1.
			ball := 1]
		ifFalse: [
			ball := ball + 1].
	self updateScore.
	pinCountList add: pinCount.
	^ true
! !

!BowlingScore methodsFor: 'access functions' stamp: 'DY 2/9/2004 15:20'!
putSpare

	frame < 10 & (ball ~~ 2) ifTrue: [ ^false ].
	frame < 10 & (ball == 2) & (((pins at: frame) at: 1) = 10) ifTrue: [ ^false ].
	(ball = 2) & (((pins at: frame) at: 1) ~~ 10) ifTrue: [ ^ self putBall: 10 - ((pins at: frame) at: 1) ].
	frame = 10 && (ball == 3) & (((pins at: 10) at: 1) == 10) & (((pins at: 10) at: 2) ~~ 10) ifTrue: [
		^ self putBall: 10 - ((pins at: frame) at: 2) ].
	^false! !

!BowlingScore methodsFor: 'access functions' stamp: 'DY 1/28/2004 22:48'!
scoreInFrame: f

	(self bowlerIsPast: f) ifTrue: [^ score at: f ].
	^ score at: lastFrameScored! !

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

BowlingScore class
	instanceVariableNames: ''!

!BowlingScore class methodsFor: 'class initialization' stamp: 'DY 1/28/2004 18:32'!
new
^super new! !
